<?php

namespace Modules\Subscribe\Traits;

use Modules\LMS\Enums\PurchaseType;
use Modules\Subscribe\Models\Subscribe\Subscribe;
use Modules\Subscribe\Models\Subscribe\SubscribeUse;

use function PHPSTORM_META\type;

trait PurchaseExpiryCheckTrait
{
    /**
     * Get the subscription used for a specific purchase.
     *
     * @param int $user_id
     * @param int $itemId
     * @param int $purchaseId
     * @return Subscribe|null
     */
    public static function getUsedSubscribe($user_id, $itemId, $purchaseId, $type = "course")
    {


        $subscribe = null;
        $use = $use = SubscribeUse::where('sale_id', $purchaseId)
            ->where($type === "course" ? 'course_id' : 'bundle_id', $itemId)
            ->where('user_id', $user_id)
            ->first();
        if (!empty($use)) {
            $subscribe = Subscribe::where('id', $use->subscribe_id)->first();
        }
        return $subscribe;
    }

    /**
     * Check if a purchase with a subscription has expired.
     *
     * @param int $itemId
     * @param string $itemName
     * @return bool
     */
    public static function checkExpiredPurchaseWithSubscribe($purchaseId, $itemId, $type = "course")
    {
        $user_id = authCheck()->id;
        $result = true;
        $subscribe = self::getUsedSubscribe($user_id, $itemId, $purchaseId, $type);
        if (!empty($subscribe)) {
            $subscribeSale = self::where('user_id', $user_id)
                ->where('purchase_type', PurchaseType::SUBSCRIBE)
                ->where('subscribe_id', $subscribe->id)
                ->latest('created_at')
                ->first();
            if (!empty($subscribeSale)) {
                $usedDays = (int) get_diff_timestamp_day(now(), $subscribeSale->created_at);
                if ($usedDays <= $subscribe->days) {
                    $result = false;
                }
            }
        }
        return $result;
    }
}
