<?php

namespace Modules\Subscribe\Http\Controllers;

use App\Http\Controllers\Controller;
use Flasher\Laravel\Http\Request;
use Illuminate\Support\Facades\View;
use LDAP\Result;
use Modules\Subscribe\Repositories\Subscribe\SubscribeRepository;
use Modules\Subscribe\Services\SubscribeService;

class SubscribeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function apply($slug)
    {
        $type  = Request()->get('type') ??  'course';
        if (!authCheck()) {
            return redirect()->route('login');
        }
        $response = SubscribeService::applySubscribe($slug,  $type);

        if ($response['status'] == 'error') {
            toastr()->error($response['message']);
        } else {
            toastr()->success($response['message']);
        }
        return redirect()->back();
    }


    /**
     * Method subscriptionList
     *
     * @return View
     */
    public function subscriptionList()
    {
        $response =  SubscribeRepository::get(options: ['where' =>  ['status', 1]]);
        $subscribes = $response['data'] ?? [];
        $data = [
            'subscribes' => $subscribes,
            'activePlan' => SubscribeService::getActiveSubscribe(),
            'dayOfUse' => SubscribeService::getDayOfUse(),
        ];
        return view('portal::student.subscription.index', $data);
    }
}
