<?php

use Illuminate\Support\Facades\Route;
use Modules\Subscribe\Http\Controllers\SubscribeController;
use Modules\Subscribe\Http\Controllers\Admin\SubscribeController as AdminSubscribeController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(
    ['prefix' => 'admin', 'middleware' => ['auth:admin']],
    function () {
        Route::resource('subscribe', AdminSubscribeController::class);
        Route::get('status-change/{id}', [AdminSubscribeController::class, 'statusChange'])->name('subscribe.status');
        Route::put('subscribe/restore/{id}', [AdminSubscribeController::class, 'restore'])->name('subscribe.restore');
        Route::get('subscribe/{id}/translate/{locale}', [AdminSubscribeController::class, 'edit'])->name('subscribe.translate');
    });

Route::group(
    ['prefix' => 'dashboard', 'as' => 'student.', 'middleware' => ['auth', 'role:Student', 'checkInstaller']],
    function () {
        Route::group(['controller' => SubscribeController::class], function () {
            Route::get('subscriptions', 'subscriptionList')->name('subscribe.list');
        });
    }
);

Route::group(['prefix' => 'subscribe', 'controller' => SubscribeController::class], function () {
    Route::get('apply/{slug}', 'apply')->name('subscribe.apply');
});
