<?php

namespace Modules\Subscribe\Repositories\Subscribe;

use Modules\LMS\Repositories\BaseRepository;
use Modules\Subscribe\Models\Subscribe\Subscribe;
use Modules\Subscribe\Models\Subscribe\SubscribeUse;

class SubscribeRepository extends BaseRepository
{
    protected static $model = Subscribe::class;

    protected static $exactSearchFields = [];

    protected static $excludedFields = [
        'save' => [
            'image',
            '_token',
            'locale'
        ],
        'update' => ['image', '_token', '_method', 'locale'],
    ];

    protected static $rules = [
        'save' => [
            'title' => 'required|string',
            'description' => 'required|string',
            'usable_count' => 'required',
            'days' => 'required',
            'price' => 'required',
        ],
        'update' => [
            'title' => 'required|string',
            'description' => 'required|string',
            'usable_count' => 'required|string',
            'days' => 'required',
            'price' => 'required',
        ],
    ];

    /**
     * @param  mixed  $request
     */
    public static function save($request): array
    {
        if ($request->hasFile('image')) {
            static::$rules['save']['image'] = 'required|image|mimes:jpg,jpeg,png,svg,webp';
            $iconImg = parent::upload($request, fieldname: 'image', file: '', folder: 'lms/subscribes');
            $request->merge(['icon_img' => $iconImg]);
        }
        $request->merge([
            'is_popular' => $request->is_popular == 'on' ? 1 : 0
        ]);
        $response = parent::save($request->all());
        $subscribe = $response['data'] ?? null;
        if ($response['status'] === 'success' && $subscribe) {
            $data = self::translateData($request->all());
            self::translate($subscribe, $data, locale: $request->locale ?? app()->getLocale());
        }
        return $response;
    }

    /**
     * @param  int  $id
     * @param  array  $data
     */
    public static function update($id, $request): array
    {

        $response = parent::first(value: $id);
        $subscribe = $response['data'] ?? null;

        if (! $subscribe) {
            return [
                'status' => 'error',
                'data' => 'The model not found.',
            ];
        }

        $data = self::translateData($request->all());
        $defaultLanguage = app()->getLocale();
        self::translate(subscribe: $subscribe,  data: $data, locale: $request->locale);

        if ($request->locale &&  $defaultLanguage !== $request->locale) {
            return [
                'status' => 'success',
                'data' => $subscribe,
            ];
        }

        if ($request->hasFile('image')) {
            static::$rules['update']['image'] = 'required|image|mimes:jpg,jpeg,png,svg,webp';
            $iconImg = parent::upload($request, fieldname: 'image', file: $subscribe?->icon_img, folder: 'lms/subscribes');
            $request->merge([
                'icon_img' => $iconImg,
            ]);
        }

        $request->merge([
            'is_popular' => $request->is_popular == 'on' ? 1 : 0
        ]);
        $response = parent::update($id, $request->all());
        return $response;
    }

    /**
     *  delete
     *
     * @param  $id  $id
     */
    public static function delete($id, $data = [], $options = [], $relations = []): array
    {
        $response = parent::first($id, withTrashed: true);
        $testimonial = $response['data'] ?? null;
        if ($response['status'] == 'success' && $testimonial) {

            $isDeleteAble = true;
            if (static::isSoftDeleteEnable() && ! $testimonial->trashed()) {
                $isDeleteAble = false;
            }

            if ($isDeleteAble) {
                parent::fileDelete(folder: 'lms/subscribes', file: $testimonial->profile_image);
            }
            return parent::delete($id, $data);
        }
        return $response;
    }

    /**
     *  statusChange
     */
    public static function statusChange($id): array
    {
        $response = parent::first($id);
        $subscribe = $response['data'];
        $subscribe->status = ! $subscribe->status;
        $subscribe->update();

        return [
            'status' => 'success',
            'message' => translate('Status Change Successfully')
        ];
    }
    public static function translateData(array $data)
    {
        $data = [
            'title' => $data['title'],
        ];
        return $data;
    }

    public static function translate($subscribe, $data, $locale)
    {
        $subscribe->translations()->updateOrCreate(['locale' => $locale], [
            'locale' => $locale,
            'data' => $data
        ]);
    }


    public static function useSubscribe($subscribeId, $itemId, $saleId, $type = "course")
    {
        SubscribeUse::create([
            'user_id' => authCheck()->id,
            'subscribe_id' => $subscribeId,
            'course_id' =>   $type == 'course' ? $itemId : null,
            'bundle_id' =>   $type == 'bundle' ? $itemId : null,
            'sale_id' => $saleId
        ]);
    }
}
